*Title: What are Scheduled Tasks? How to set them?
*Slug: scheduled-tasks-setup

================================================================

Some activeCollab modules and functionalities need to be pinged periodically in order to perform their tasks and main purpose. For example, the Invoicing module should be run daily if you wish to automatically create and send invoices configured using the <{page name="monthly-invoices" book="invoicing"}>Recurring Profiles<{/page}> feature.

All of these events are executed by periodically **making a web request on specific activeCollab URL/URLs or by executing specific PHP files through command lines**. There are three time periods which activeCollab supports:

- **Frequently** - Should be executed frequently. We recommend every 3 minutes, but you can use any value between 1 - 5 minutes.
- **Hourly** - Should be executed every hour.
- **Daily** - Should be executed every day.

Command examples with exact paths and URL/URLs that need to be triggered are described below.

<{note title="Scheduled Tasks Troubleshooting"}>In case that one of the Scheduled Tasks is not triggered on time, you will see a warning about it in the <{option}>Admin Additional Menu<{/option}>. You can visit <{option}>Admin > Scheduled Tasks<{/option}> to check the last time that one of these events was triggered and to see which one is malfunctioning<{/note}>

<{sub}>Operations Dependent on Scheduled Tasks<{/sub}>

Various operations depend on Scheduled Tasks. You can find out which operation is triggered by what kind of a Scheduled task here:

<{term}>Frequently<{/term}> tasks are responsible for:

- Sending outgoing email notifications for the mailing queue.
- Importing email messages from defined mailboxes.
- Sending reminders that are set to be sent at a given date and time.
- Checking source repositories for new commits.

<{term}>Hourly Scheduled Tasks<{/term}>  take care of:

- Cleaning up environment cache.
- Checking source repositories for new commits.

<{term}>Daily<{/term}> task is used:

- To send recurring invoices for a given day.
- Checking source repositories for new commits.
- Cleaning up various caches and commit daily summaries.

<{sub}>Methods of Triggering Scheduled Tasks<{/sub}>

There are two ways to trigger Scheduled Tasks for your activeCollab:

1. **by triggering a scheduled task URL with a utility such as curl, wget, etc.**
2. **by executing a specific PHP file using a PHP command line utility.**

Of course, both approaches have advantages and disadvantages. For example, using PHP to trigger files skips the web server and the overhead that it adds, but you will need to have the PHP command line utility configured on your server. On the other hand, triggering a URL always works when activeCollab is properly configured, but it is a little slower because the web server is added to the mix. In general, it is completely up to you which method you will be using, the end results will be the same.

<{image name="scheduled_tasks.png"}>

<{sub}> Trigger Tasks with cron (Linux, BSD, etc)<{/sub}>

To trigger Scheduled Tasks, you will have to set up scheduling software to execute task scripts or to ping specific activeCollab URLs at defined time.

For example, **on UNIX you can use cron and PHP or curl** to achieve this. Open crontab for editing by executing <{code}>crontab -e<{/code}> in your command line. Then insert the following text into the field:

<{code}>*/3       *      *       *       *       php "/path/to/activecollab/tasks/frequently.php" > /dev/null
0         *      *       *       *       php "/path/to/activecollab/tasks/hourly.php" > /dev/null
0        12      *       *       *       php "/path/to/activecollab/tasks/daily.php" > /dev/null<{/code}>

Save the changes. This will "tell" PHP to execute task files:

- Every 3 minutes for frequently tasks.
- On an hourly script on 0 minute of every hour.
- On a daily script every day at noon.

If the PHP command line interface is not available on your server, you can use curl to request specific URLs to trigger events. activeCollab behaves the same way as task files, but instead of using a PHP command line utility, tasks are invoked by the web server. Here are the commands that you will need to set in the crontab file:

<{code}>*/3       *      *       *       *       /usr/bin/curl -s -L "http://url/of/frequently/task" > /dev/null
0         *      *       *       *       /usr/bin/curl -s -L "http://url/of/hourly/task" > /dev/null
0        12      *       *       *       /usr/bin/curl -s -L "http://url/of/daily/task" > /dev/null<{/code}>

<{sub}>Trigger Tasks with Scheduled Tasks (Windows)<{/sub}>

On Windows server you can also use Scheduled Tasks to trigger activeCollab. To set-up Scheduled Tasks on Windows XP, Vista and Windows 7 (as well as Windows 2003 Server, or later) you can use schtasks.exe. To achieve that, open the command line and type in the following commands:

<{code}>schtasks /create /ru "System" /sc minute /mo 3 /tn "activeCollab frequently job" /tr "C:\php\php.exe C:\activecollab\tasks\frequently.php -f"
schtasks /create /ru "System" /sc hourly /st 12:00:00 /tn "activeCollab hourly job" /tr "C:\php\php.exe C:\activecollab\tasks\hourly.php -f"
schtasks /create /ru "System" /sc daily /st 12:00:00 /tn "activeCollab daily job" /tr "C:\php\php.exe C:\activecollab\tasks\daily.php -f"<{/code}>

<{note title="Important Details for This Setup"}>
- Use the real path to your php.exe file.
- Use exact paths to frequently.php, daily.php and hourly.php files, as found on the <{option}>Administration > Scheduled Tasks<{/option}> page.
- If you have white spaces in you paths to php.exe or activecollab folder you need to add \" to escape it. For example, cases like this:

<{code}>schtasks /create /ru "System" /sc minute /mo 3 /tn "activeCollab frequently job" /tr "C:\Program Files (x86)\php\php.exe C:\activecollab\tasks\frequently.php -f"<{/code}>

could be avoided by using:

<{code}>schtasks /create /ru "System" /sc minute /mo 3 /tn "activeCollab frequently job" /tr "\"C:\Program Files (x86)\php\php.exe\" C:\activecollab\tasks\frequently.php -f<{/code}><{/note}>

<{sub}>Trigger Tasks with launchd (Mac OS X)<{/sub}>

On Mac OS 10.4 or later, Apple recommends that you use launchd instead of cron, xinetd, mach_init, and init. Scheduled Tasks are defined as XML files that will instruct launchd what to do and when.

To define the three scheduled tasks that activeCollab requires, please create the following files in the /Library/LaunchAgents folder and make sure that you set the correct Scheduled Task URLs:

- **com.a51.activeCollabFrequently.plist**

<{code}><?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
    <key>Label</key>
    <string>com.a51.activeCollabFrequently</string>
    <key>ProgramArguments</key>
    <array>
        <string>/usr/bin/curl</string>
        <string>-s</string>
        <string>-L</string>
        <string>https://my.activecollab.info/frequently?code=12345</string>
    </array>
    <key>StandardOutPath</key>
    <string>/dev/null</string>
    <key>StandardErrorPath</key>
    <string>/tmp/ac_schedule_err.log</string>
    <key>RunAtLoad</key>
    <true/>
    <key>StartInterval</key>
    <integer>180</integer>
</dict>
</plist><{/code}>


- **com.a51.activeCollabHourly.plist**

<{code}><?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
    <key>Label</key>
    <string>com.a51.activeCollabHourly</string>
    <key>ProgramArguments</key>
    <array>
        <string>/usr/bin/curl</string>
        <string>-s</string>
        <string>-L</string>
        <string>https://my.activecollab.info/hourly?code=12345</string>
    </array>
    <key>StandardOutPath</key>
    <string>/dev/null</string>
    <key>StandardErrorPath</key>
    <string>/tmp/ac_schedule_err.log</string>
    <key>StartCalendarInterval</key>
    <dict>
        <key>Minute</key>
        <integer>0</integer>
    </dict>
</dict>
</plist><{/code}>

- **com.a51.activeCollabDaily.plist**

<{code}><?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
    <key>Label</key>
    <string>com.a51.activeCollabDaily</string>
    <key>ProgramArguments</key>
    <array>
        <string>/usr/bin/curl</string>
        <string>-s</string>
        <string>-L</string>
        <string>https://my.activecollab.info/daily?code=12345</string>
    </array>
    <key>StandardOutPath</key>
    <string>/dev/null</string>
    <key>StandardErrorPath</key>
    <string>/tmp/ac_schedule_err.log</string>
    <key>StartCalendarInterval</key>
    <dict>
        <key>Hour</key>
        <integer>12</integer>
        <key>Minute</key>
        <integer>0</integer>
    </dict>
</dict>
</plist><{/code}>







